import type { NavigationItem, SidebarNavigationItem } from "@/types/navigation";

export const routesConfig = {
  navigation: [
    {
      title: "Upload",
      to: "/admin/upload",
      disabled: false,
    },
    {
      title: "Registry",
      to: "/admin/registry",
      disabled: false,
    },
  ] satisfies NavigationItem[],
  extended: [
    {
      title: "Admin",
      items: [
        {
          title: "Upload files",
          to: "/admin/upload",
          disabled: false,
          label: "",
        },
        {
          title: "Registry",
          to: "/",
          disabled: false,
          label: "under construction",
        },
      ],
    },
  ] satisfies SidebarNavigationItem[],
} as const;

export type RoutesConfig = typeof routesConfig;
